public class Times {
	private int secTotal;
	private int secFischer;
	private int secBronstein;
	private int secBronsteinActual;
	
	public int getSecTotal(){
		return secTotal;
	}
	
	public void setSecTotal(int h, int m, int s){
		secTotal=h*3600+m*60+s;
	}
	
	public int getSecFischer() {
		return secFischer;
	}
	
	public void setSecFischer(int m, int s){
		secFischer=m*60+s;
	}
	
	public int getSecBronstein(){
		return secBronstein;
	}
	
	public void setSecBronstein(int m, int s){
		secBronstein=m*60+s;
		secBronsteinActual=secBronstein;
	}
	
	public int getSecBronsteinActual(){
		return secBronsteinActual;
	}	
	
	public String toString(int sec, boolean big) {
		String s="";
		if (big) {
			s+=sec/3600+":";
			int min=(sec%3600)/60;
			if (min<10) s+="0";
			s+=min+":";
			sec=sec%60;
			if (sec<0) {
				s="-"+s;
				sec=Math.abs(sec);
			}
			if (sec<10) s+="0";
			s+=sec;
			return s;
		}
		else {
			s+=sec/60+":";
			sec=sec%60;
			if (sec<10) {
				s+="0";
			}
			s+=sec;
			return s;
		}

	}
	
	public String secTotalToString(){
		return toString(secTotal, true);
	}
	
	public String secFischerToString() {
		return toString(secFischer, false);
	}
	
	public String secBronsteinToString(){
		return toString(secBronstein, false);
	}
	
	public String secBronsteinActualToString() {
		return toString (secBronsteinActual, false);
	}
	
	public void secondPassed(){
		switch (Clock.gameType) {
		case 0: //Normal
			secTotal-=1;
			break;
		case 1: //Fischer
			secTotal-=1;
			break;
		case 2: //Bronstein
			if (secBronsteinActual<=0) secTotal-=1;
			else secBronsteinActual-=1;
			break;
		}
	}
	
	public void moveDone(){
		switch (Clock.gameType) {
		case 0: //Normal
			break;
		case 1: //Fischer
			secTotal+=secFischer;
			break;
		case 2: //Bronstein
			secBronsteinActual=secBronstein;
			break;
		}
	}
}
