import java.awt.*;
import java.awt.event.*;
import java.applet.*;

public class Clock extends Applet {
	//GUIvariablen Beginn
	private static Button bStart;
	private static Button bPause;
	private static Button bEnd;
	private static Button bMove;
	private static Label lWhite;
	private static Label lBlack;
	private static Label lBlacksTurn;
	private static Label lWhitesTurn;
	protected static TextField tfWhiteTotal;
	protected static TextField tfBlackTotal;
	protected static TextField tfWhiteMove;
	protected static TextField tfBlackMove;
	protected static TextField tfWhitePlus;
	protected static TextField tfBlackPlus;
	//Ende
	
	protected static Times timesBlack;
	protected static Times timesWhite;
	protected static boolean whiteToMove;
	protected static boolean gameStarted;
	protected static boolean gameRunning;
	protected static boolean firstMove;
	protected static byte gameType; // 0 - Normal, 1 - Fischer, 2 - Bronstein
	protected static final threadTimer t=new threadTimer();
	
	public void init() {
		Font fMain=new Font ("", Font.BOLD, 16);
		Font fTotalTime=new Font("", 0, 46);
		Font fMoveTime=new Font("", 0, 30);
		this.setSize(1200,600);
		this.setLayout(new BorderLayout());
		this.setBackground(Color.lightGray);
		
		Panel pNorth=new Panel();
		pNorth.setLayout(new GridLayout(1,3));
			bStart=new Button ("start");
				bStart.setFont(fMain);
			pNorth.add(bStart);
			bPause = new Button ("pause");
				bPause.setFont(fMain);
				bPause.setEnabled(false);
			pNorth.add(bPause);
			bEnd = new Button ("end");
				bEnd.setFont(fMain);
				bEnd.setEnabled(false);
			pNorth.add(bEnd);
		add(pNorth, BorderLayout.NORTH);
		
		Panel pTime=new Panel();
		pTime.setLayout(new GridLayout(5,1));
		
		
		
		Panel pWhiteBlack=new Panel();
			lWhitesTurn=new Label(">>");
				lWhitesTurn.setBackground(Color.green);
				lWhitesTurn.setFont(fMain);
			pWhiteBlack.add(lWhitesTurn);
			lWhite=new Label("WHITE  ");
				lWhite.setForeground(Color.white);
				lWhite.setFont(fMain);
			pWhiteBlack.add(lWhite);
			lBlack=new Label("  BLACK");
				lBlack.setForeground(Color.black);
				lBlack.setFont(fMain);
			pWhiteBlack.add(lBlack);
			lBlacksTurn=new Label("<<");
				lBlacksTurn.setBackground(Color.green);
				lBlacksTurn.setFont(fMain);
			pWhiteBlack.add(lBlacksTurn);
		pTime.add(pWhiteBlack);

		Panel pTotalTime=new Panel();
			Label lTotalTime=new Label("total time");
				lTotalTime.setFont(fMain);
			pTotalTime.add(lTotalTime);
			tfWhiteTotal=new TextField("0:00:00");
				tfWhiteTotal.setColumns(8);
				tfWhiteTotal.setFont(fTotalTime);
			pTotalTime.add(tfWhiteTotal);
			Label lFormatBig = new Label ("(h:mm:ss)");
				lFormatBig.setFont(new Font("", 0, 16));
			pTotalTime.add(lFormatBig);
			tfBlackTotal=new TextField("0:00:00");
				tfBlackTotal.setColumns(8);
				tfBlackTotal.setFont(fTotalTime);
			pTotalTime.add(tfBlackTotal);
			Label lTotalTime2=new Label("total time");
				lTotalTime2.setFont(fMain);
			pTotalTime.add(lTotalTime2);
		pTime.add(pTotalTime);
		
		Panel pTimeToMove=new Panel();
			Label lTimeToMove=new Label("add. time / move");
				lTimeToMove.setFont(fMain);
			pTimeToMove.add(lTimeToMove);
			tfWhiteMove=new TextField("0:00");
				tfWhiteMove.setColumns(8);
				tfWhiteMove.setFont(fMoveTime);
			pTimeToMove.add(tfWhiteMove);
			Label lFormatSmall = new Label ("(m:ss)");
				lFormatSmall.setFont(new Font("", 0, 14));
			pTimeToMove.add(lFormatSmall);
			tfBlackMove=new TextField("0:00");
				tfBlackMove.setColumns(8);
				tfBlackMove.setFont(fMoveTime);
			pTimeToMove.add(tfBlackMove);
			Label lTimeToMove2=new Label("add. time / move");
				lTimeToMove2.setFont(fMain);
			pTimeToMove.add(lTimeToMove2);
		pTime.add(pTimeToMove);
		
		Panel pMode=new Panel();
			Label lMode=new Label("Mode: ");
				lMode.setFont(fMain);
			pMode.add(lMode);
			final Choice cMode=new Choice();
				cMode.add("Normal");
				cMode.add("Fischer");
				cMode.add("Bronstein");
				cMode.setFont(fMain);
			pMode.add(cMode);
		pTime.add(pMode);
		
		
		add(pTime, BorderLayout.CENTER);

		Label lW=new Label("          ");
			lW.setFont(fMain);
			lW.setBackground(Color.white);
		add(lW, BorderLayout.WEST);
		Label lB=new Label("          ");
			lB.setFont(fMain);
			lB.setBackground(Color.black);
		add(lB, BorderLayout.EAST);
		bMove=new Button ("M O V E");
			bMove.setFont(new Font("", Font.BOLD, 24));
			bMove.setEnabled(false);
		add(bMove, BorderLayout.SOUTH);
		
		firstMove=true;
		timesWhite=new Times();
		timesBlack=new Times();
		
		
		bStart.addMouseListener (
			new MouseAdapter() {
				public void mouseClicked(MouseEvent mee) {
					gameStarted=true;
					firstMove=true;
					lWhitesTurn.setVisible(true);
					lBlacksTurn.setVisible(false);
					bStart.setEnabled(false);
					bEnd.setEnabled(true);
					bMove.setEnabled(true);
					gameType=(byte) cMode.getSelectedIndex();
					int h, m, s;
					h=tfWhiteTotal.getText().charAt(0)-48;
					m=10*(tfWhiteTotal.getText().charAt(2)-48)+tfWhiteTotal.getText().charAt(3)-48;
					s=10*(tfWhiteTotal.getText().charAt(5)-48)+tfWhiteTotal.getText().charAt(6)-48;
					timesWhite.setSecTotal(h, m, s);
					tfWhiteTotal.setText(timesWhite.secTotalToString());
					
					h=tfBlackTotal.getText().charAt(0)-48;
					m=10*(tfBlackTotal.getText().charAt(2)-48)+tfBlackTotal.getText().charAt(3)-48;
					s=10*(tfBlackTotal.getText().charAt(5)-48)+tfBlackTotal.getText().charAt(6)-48;
					timesBlack.setSecTotal(h, m, s);
					tfBlackTotal.setText(timesBlack.secTotalToString());
					
					switch (gameType) {
					case 0: //Normal
						break;
					case 1: //Fischer
						m=tfWhiteMove.getText().charAt(0)-48;
						s=10*(tfWhiteMove.getText().charAt(2)-48)+tfWhiteMove.getText().charAt(3)-48;
						timesWhite.setSecFischer(m, s);
						tfWhiteMove.setText(timesWhite.secFischerToString());
						
						m=tfBlackMove.getText().charAt(0)-48;
						s=10*(tfBlackMove.getText().charAt(2)-48)+tfBlackMove.getText().charAt(3)-48;
						timesBlack.setSecFischer(m, s);			
						tfBlackMove.setText(timesBlack.secFischerToString());
						break;
					case 2: //Bronstein
						m=tfWhiteMove.getText().charAt(0)-48;
						s=10*(tfWhiteMove.getText().charAt(2)-48)+tfWhiteMove.getText().charAt(3)-48;
						timesWhite.setSecBronstein(m, s);
						tfWhiteMove.setText(timesWhite.secBronsteinToString());
						
						m=tfBlackMove.getText().charAt(0)-48;
						s=10*(tfBlackMove.getText().charAt(2)-48)+tfBlackMove.getText().charAt(3)-48;
						timesBlack.setSecBronstein(m, s);	
						tfBlackMove.setText(timesBlack.secBronsteinToString());
						break;
					}
					bMove.requestFocus();
				}
			}
		);
		
		bPause.addMouseListener(
			new MouseAdapter() {
				public void mouseClicked(MouseEvent mee) {
					gameRunning=(!gameRunning);	
					if (gameRunning) {
						bMove.setEnabled(true);
					}
					else {
						bMove.setEnabled(false);
					}
				}
			}
		
		);
		
		bEnd.addMouseListener(
			new MouseAdapter() {
				public void mouseClicked(MouseEvent mee) {
					gameEnded();
				}
			}
		);
		
		bMove.addMouseListener(
				new MouseAdapter() {
					public void mouseClicked(MouseEvent mee2){
						moveChanged();
					}
				}
		);
		bMove.addKeyListener(
				new KeyListener() {

					public void keyPressed(KeyEvent arg0) {						
					}

					public void keyReleased(KeyEvent arg0) {						
					}

					public void keyTyped(KeyEvent arg0) {
						moveChanged();
					}
				}
		);
	}
	
	protected static final void gameEnded(){
		gameStarted=false;
		gameRunning=false;
		bStart.setEnabled(true);
		bPause.setEnabled(false);
		bEnd.setEnabled(false);
		bMove.setEnabled(false);
	}
	
	
	
	private static final void moveChanged() {
		if (gameStarted && firstMove) {
			firstMove=false;
			gameRunning=true;
			whiteToMove=false;
			lWhitesTurn.setVisible(false);
			lBlacksTurn.setVisible(true);
			bPause.setEnabled(true);
			try { t.start(); }
			catch (IllegalThreadStateException te) {};
		}
		else {
			whiteToMove=(!whiteToMove);
			if (whiteToMove){
				Clock.timesBlack.moveDone();
				if (gameType==1) tfBlackTotal.setText(timesBlack.secTotalToString());
				if (gameType==2) tfBlackMove.setText(timesBlack.secBronsteinToString());
				lWhitesTurn.setVisible(true);
				lBlacksTurn.setVisible(false);
				
			}
			else {
				Clock.timesWhite.moveDone();
				if (gameType==1) tfWhiteTotal.setText(timesWhite.secTotalToString());
				if (gameType==2) tfWhiteMove.setText(timesWhite.secBronsteinToString());
				lWhitesTurn.setVisible(false);
				lBlacksTurn.setVisible(true);
			}
		}

	}
}

